import type { Metadata } from "next";
import { Noto_Sans } from "next/font/google";
import "../globals.css";
import { SessionProvider } from "next-auth/react";
import {NextIntlClientProvider} from 'next-intl';
import {getMessages} from 'next-intl/server';
import { Toaster } from "@/components/ui/sonner"

const noto = Noto_Sans({ subsets: ["latin"] });

export const metadata: Metadata = {
  title: "Create Next App",
  description: "Generated by create next app",
};

export default async  function RootLayout({
  children,
  params: {locale}
}: Readonly<{
  children: React.ReactNode;
  params: {locale: string};
}>) {

  const messages = await getMessages();
  return (
    <html lang={locale}>
      <body className={noto.className}>
          <NextIntlClientProvider messages={messages}>
          {children}
          <Toaster position="top-center" richColors/>
          </NextIntlClientProvider>
      </body>
    </html>
  );
}
